<?php $__env->startSection('content'); ?>


<section class="page-blog header">
     <div class="hero-section d-flex">
            <div class="text-desc ">
                <h1 class="fw-bold">Mantenha-se sempre actualizado</h1>
                <p class="small my-4 text-muted">Lorem ipsum dolor sit amet consectetur, adipisicing elit. Dolorum quos, vero minima fugiat a numquam rerum cum odio aperiam repudiandae distinctio? Quae quaerat cupiditate ipsa excepturi temporibus obcaecati tempore eveniet.</p>
            </div>

           <div class="hero-img ">
                <img src="<?php echo e(asset('assets/img/background18.jpg')); ?>" alt="image-2" width="200">
           </div>
    </div>
</section>


<section class="news">
    <div class="filters-menu ">
        <ul class="d-flex list-unstyled justify-content-center gap-4">
            <li class="<?php echo e(!request()->has('tipo') ? 'active' : ''); ?>">
                <a href="<?php echo e(route('blog')); ?>" class="text-decoration-none">
                    Todas noticias
                </a>
            </li>

            <li class="<?php echo e(request('tipo') == 'actualizacoes' ? 'active' : ''); ?>">
                <a href="<?php echo e(route('blog', ['tipo' => 'actualizacoes'])); ?>" class="text-decoration-none">
                    Actualizações
                </a>
            </li>

            <li class="<?php echo e(request('tipo') == 'projectos' ? 'active' : ''); ?>">
                <a href="<?php echo e(route('blog', ['tipo' => 'projectos'])); ?>" class="text-decoration-none">
                    Projectos
                </a>
            </li>

            <li class="<?php echo e(request('tipo') == 'tendencias' ? 'active' : ''); ?>">
                <a href="<?php echo e(route('blog', ['tipo' => 'tendencias'])); ?>" class="text-decoration-none">
                    Tendências
                </a>
            </li>

            <li class="<?php echo e(request('tipo') == 'dicas' ? 'active' : ''); ?>">
                <a href="<?php echo e(route('blog', ['tipo' => 'dicas'])); ?>" class="text-decoration-none">
                    Dicas de Construção
                </a>
            </li>
        </ul>


        <form method="GET" action="<?php echo e(route('blog')); ?>" class="btn-filter-toggle d-none w-100 d-flex gap-2">
                <div class="input-field w-100">
                    <select name="tipo" class="form-select">
                        <option value=""
                        <?php echo e(!request()->has('tipo') ? 'active' : ''); ?>>Todas</option>

                        <option value="actualizacoes"
                            <?php echo e(request('tipo') === 'actualizacoes' ? 'selected' : ''); ?>>
                            Actualizações
                        </option>

                        <option value="projectos"
                            <?php echo e(request('tipo') === 'projectos' ? 'selected' : ''); ?>>
                            Projectos
                        </option>

                        <option value="tendencias"
                            <?php echo e(request('tipo') === 'tendencias' ? 'selected' : ''); ?>>
                            Tendências
                        </option>

                        <option value="dicas"
                            <?php echo e(request('tipo') === 'dicas' ? 'selected' : ''); ?>>
                            Dicas de Construção
                        </option>
                    </select>
                </div>

                <button class="btn btn-dark" type="submit">
                    <i class="bx bx-filter-alt"></i> Filtrar
                </button>
        </form>


    </div>

    <div class="news-content">
        <div class="news-content-item d-flex" style="gap:20px">
            <?php if(!$destaque): ?>
                <p class="fs-3 text-center fw-bold">Não existe destaque</p>
            <?php else: ?>
            <div class="featured-news w-100">
                <div class="image">
                    <img src="<?php echo e(asset('storage/' .$destaque->path_imagem)); ?>" alt="<?php echo e($destaque->titulo_noticia); ?>" width="200"/>
                    <p>Destaque</p>
                </div>
                <div class="desc">
                    <p class="fs-4"><?php echo e($destaque->titulo_noticia); ?></p>
                    <p class="text-muted"><?php echo e($destaque->descricao); ?></p>
                    <p class="text-muted d-flex" style="gap:10px;font-size:12px">
                        <span class="by">By <?php echo e($destaque->autor_noticia); ?></span>
                        <span>|</span>
                        <span>Publicado em <?php echo e($destaque->data_publicacao->format('d/m/Y')); ?></span>
                    </p>
                    <a href="">Ler mais</a>
                </div>
            </div>
            <?php endif; ?>
            <div class="stories w-100">
                <p>Últimos históricos</p>
                <div class="stories-card p-4">
                    <?php $__currentLoopData = $ultimas_noticias; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $un): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="stories-card-item">
                        <div class="image"><img src="<?php echo e(asset('storage/' .$un->path_imagem)); ?>" alt="<?php echo e($destaque->titulo_noticia); ?>" width="80"></div>
                        <div class="desc">
                            <p class="small m-0"><?php echo e($un->titulo_noticia); ?></p>
                            <p class="text-muted m-0 d-flex" style="gap:10px;font-size:12px">
                                <span class="by">By <?php echo e($un->autor_noticia); ?></span>
                                <span>|</span>
                                <span>Publicado em <?php echo e($un->data_publicacao->format('d/m/Y')); ?></span>
                            </p>
                            <a href="">Ler mais</a>
                        </div>
                    </div>
                    <hr style="color:#D8DCE1;">
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
        <hr style="color:#D8DCE1;">
        <p class="title mt-5">Outras notícias</p>
        <div class="card-news-content mb-3 p-4 d-flex">
            <?php $__currentLoopData = $noticias; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $noticia): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="card-news-content-item shadow-sm flex-fill">
                    <div class="image"><img src="<?php echo e(asset('storage/' .$noticia->path_imagem)); ?>" alt="<?php echo e($destaque->titulo_noticia); ?>" width="80"></div>
                    <div class="desc">
                        <p class="small m-0"><?php echo e($noticia->titulo_noticia); ?></p>
                        <p class="text-muted m-0 d-flex" style="gap:10px;font-size:12px">
                            <span class="by">By <?php echo e($noticia->autor_noticia); ?></span>
                            <span>|</span>
                            <span>Publicado em <?php echo e($noticia->data_publicacao->format('d/m/Y')); ?></span>
                        </p>
                        <a href="">Ler mais</a>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        </div>
        <?php echo $__env->make('components.pagination', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </div>
</section>




<?php echo $__env->make('components.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\website-van_thanh\resources\views/website/blog.blade.php ENDPATH**/ ?>