
<div class="card">
    <div class="card-header">
        <h5>Tabela de usuários</h5>
        <form method="GET" action="<?php echo e(route('usuarios.index')); ?>" id="formSearch">
        <div>
            <div class="input-group input-group-merge">
            <span id="basic-icon-default-fullname2" class="input-group-text"
                ><i class="icon-base bx bx-search"></i
            ></span>
                <input
                type="text"
                class="form-control"
                id="search"
                name="search"
                placeholder="Pesquisar"
                value="<?php echo e(request('search')); ?>"
                aria-label="Pesquisar"
                aria-describedby="basic-icon-default-fullname2" />

            </div>
        </div>
        </form>
    </div>
    <div class="table-responsive text-nowrap">
        <table class="table">
            <thead class="table-dark">
                <tr>
                <th>Nome completo</th>
                <th>E-mail de acesso</th>
                <th>Imagem</th>
                <th>Status</th>
                <th>Painel de acesso</th>
                <th>Acções</th>
                </tr>
            </thead>
            <tbody class="table-border-bottom-0">
                 <?php if($usuarios->isEmpty()): ?>
                       <tr>
                            <td colspan="7" class="text-center" style="font-size: 15px;">
                                Nenhum resultado encontrado
                            </td>
                        </tr>
                   <?php else: ?>
                       <?php $__currentLoopData = $usuarios; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $usuario): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td>
                            <?php if($usuario->painel == 'Cliente'): ?>
                            <?php echo e($usuario->cliente->nome_cliente); ?>

                            <?php else: ?>
                            <?php echo e($usuario->funcionario->nome_funcionario); ?>

                            <?php endif; ?>
                        </td>

                        <td><?php echo e($usuario->email_acesso); ?></td>

                        <td>
                            <?php if($usuario->imagem_usuario): ?>
                                <img src="<?php echo e(asset('storage/' . $usuario->imagem_usuario)); ?>" width="80" height="80" class="#" style="object-fit: cover">
                            <?php else: ?>
                                Nenhuma imagem adicionada
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php if($usuario->status): ?>
                                <span class="badge bg-label-primary me-1">Activado</span>
                            <?php else: ?>
                                <span class="badge bg-label-danger me-1">Desativado</span>
                            <?php endif; ?>
                        </td>
                        <td><?php echo e($usuario->painel); ?></td>

                        <td>
                            <div class="dropdown">
                            <button type="button" class="btn p-0 dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                                <i class="icon-base bx bx-dots-vertical-rounded"></i>
                            </button>
                            <div class="dropdown-menu">
                                <a class="dropdown-item" data-bs-toggle="modal"  href="#modal_editar_usuario<?php echo e($usuario->usuario_id); ?>"
                                ><i class="icon-base bx bx-edit-alt me-1"></i> Editar</a
                                >
                                <a class="dropdown-item" href="<?php echo e(route('usuarios.destroy', $usuario->usuario_id)); ?>"
                                ><i class="icon-base bx bx-trash me-1"></i> Deletar</a
                                >
                            </div>
                            </div>
                        </td>
                        </tr>


                        <?php echo $__env->make('dashboard.admin.pages.usuarios._includes.modal-editar-usuario', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                       <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                   <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<?php /**PATH C:\laragon\www\website-van_thanh\resources\views/dashboard/admin/pages/usuarios/_includes/tabela-usuarios.blade.php ENDPATH**/ ?>