<!-- Bootstrap Table with Header - Dark -->
<div class="card">
    <div class="card-header">
        <h5>Tabela de projectos</h5>
        <form method="GET" action="<?php echo e(route('projectos.index')); ?>" id="formSearch">
        <div>
            <div class="input-group input-group-merge">
            <span id="basic-icon-default-fullname2" class="input-group-text"
                ><i class="icon-base bx bx-search"></i
            ></span>
                <input
                type="text"
                class="form-control"
                id="search"
                name="search"
                placeholder="Pesquisar"
                value="<?php echo e(request('search')); ?>"
                aria-label="Pesquisar"
                aria-describedby="basic-icon-default-fullname2" />

            </div>
        </div>
        </form>
    </div>
    <div class="table-responsive text-nowrap">
        <table class="table">
            <thead class="table-dark">
                <tr>
                <th title="">Titulo da noticia</th>
                <th>Descrição</th>
                <th>Autor</th>
                <th>Tipo de noticia</th>
                <th>Data de publicação</th>
                <th>Acções</th>
                </tr>
            </thead>
            <tbody class="table-border-bottom-0">
                <?php if($noticias->isEmpty()): ?>
                       <tr>
                            <td colspan="7" class="text-center" style="font-size: 15px;">
                                Nenhum resultado encontrado
                            </td>
                        </tr>
                <?php else: ?>
                    <?php $__currentLoopData = $noticias; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $noticia): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                        <td title="<?php echo e($noticia->titulo_noticia); ?>" ><img src="<?php echo e(asset('storage/' .$noticia->path_imagem)); ?>" width="80" height="80" class="#" style="object-fit: cover"> <?php echo e(Str::limit($noticia->titulo_noticia, 10, '...')); ?></td>
                        <td title="<?php echo e($noticia->descricao); ?>"><?php echo e(Str::limit($noticia->descricao, 30, '...')); ?></td>
                        <td><?php echo e($noticia->autor_noticia); ?></td>
                        <td>
                            <span class="badge
                                <?php if($noticia->tipoNoticia->nome_tipo === 'Tendências'): ?> bg-label-primary
                                <?php elseif($noticia->tipoNoticia->nome_tipo === 'Actualizações'): ?> bg-label-success
                                <?php elseif($noticia->tipoNoticia->nome_tipo === 'Dicas de Construção'): ?> bg-label-danger
                                <?php elseif($noticia->tipoNoticia->nome_tipo === 'Projectos'): ?> bg-label-dark
                                <?php endif; ?>
                                me-1">
                                <?php echo e($noticia->tipoNoticia->nome_tipo); ?>

                            </span>
                        </td>
                        <td><?php echo e($noticia->data_publicacao); ?></td>
                        <td>
                            <div class="dropdown">
                            <button type="button" class="btn p-0 dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                                <i class="icon-base bx bx-dots-vertical-rounded"></i>
                            </button>
                            <div class="dropdown-menu">
                                <a class="dropdown-item" href="javascript:void(0);"
                                ><i class="icon-base bx bx-edit-alt me-1"></i> Edit</a
                                >
                                <a class="dropdown-item" href="javascript:void(0);"
                                ><i class="icon-base bx bx-trash me-1"></i> Delete</a
                                >
                            </div>
                            </div>
                        </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>


            </tbody>
        </table>
    </div>
</div>
<!--/ Bootstrap Table with Header Dark -->
<?php /**PATH C:\laragon\www\website-van_thanh\resources\views/dashboard/admin/pages/noticias/_includes/tabela-noticia.blade.php ENDPATH**/ ?>