<?php $__env->startSection('content'); ?>


<section class="page-work-us header">

    <div class="hero-section d-flex">
        <div class="text-desc ">
            <h1 class="fw-bold">Junte-se a nossa equipe</h1>
            <p class="small my-4 text-muted">Lorem ipsum dolor sit amet consectetur, adipisicing elit. Dolorum quos, vero minima fugiat a numquam rerum cum odio aperiam repudiandae distinctio? Quae quaerat cupiditate ipsa excepturi temporibus obcaecati tempore eveniet.</p>
        </div>

        <div class="hero-img ">
            <img src="<?php echo e(asset('assets/img/Search.png')); ?>" alt="image-2" width="200">
        </div>
    </div>
</section>

<section class="jobs">
    <div class="filters d-flex justify-content-center align-items-center mb-4">
        <div class="search d-flex align-items-center">
            <i class="bx bx-search"></i>
            <input type="search" placeholder="Pesquisar algo" name="search-job">
        </div>
    </div>

    <div class="card-jobs d-flex justify-content-between flex-wrap gap-4">
        <?php if($vagas->isEmpty()): ?>
            <p class="text-muted text-center w-100">Nenhuma vaga encontrada</p>
        <?php else: ?>
            <?php $__currentLoopData = $vagas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $vaga): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="card-jobs-item shadow-sm">
                    <div class="image">
                        <?php if($vaga->imagem_vaga === null): ?>
                            <img src="<?php echo e(asset('assets/img/background17.jpg')); ?>" alt="<?php echo e($vaga->nome_vaga); ?>" width="200">
                        <?php else: ?>
                            <img src="<?php echo e(asset('storage/' .$vaga->imagem_vaga)); ?>" alt="<?php echo e($vaga->nome_vaga); ?>" width="200">
                        <?php endif; ?>


                        <?php if(now()->lte($vaga->data_fim)): ?>
                            <p class="open bg-success">Aberto</p>
                        <?php else: ?>
                            <p class="open bg-success">Fechado</p>
                        <?php endif; ?>
                    </div>
                    <div class="desc p-3">
                        <p class="m-0"><?php echo e($vaga->nome_vaga); ?></p>
                        <span class="text-muted" style="font-size:12px">Inicio em <?php echo e($vaga->data_inicio); ?></span>
                        <button data-bs-toggle="modal" data-bs-target="#vagaModal<?php echo e($vaga->vaga_id); ?>">Ver detalhes</button>
                    </div>
                </div>

            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php endif; ?>
    </div>

    <div class="form p-3">
        <div class="desc text-center mb-4">
            <p class="fw-bold m-0">Formulário de candidatura</p>
            <span class="text-muted small">Lorem ipsum dolor sit amet consectetur adipisicing elit. Libero, optio odit corporis ipsam, at eveniet natus culpa repudiandae perferendis, dolorem a quia. Provident nam quidem deleniti amet. Accusamus, facilis quidem.</span>
        </div>
        <form action="<?php echo e(route('salvar-candidatura')); ?>" class="row g-3" method="post">
            <?php echo csrf_field(); ?>
            <div class="input-field col-md-6 mb-2">
                <label for="nome_candidato" class="form-label small text-muted">Nome Completo</label>
                <input type="text" class="form-control" id="nome_candidato" name="nome_candidato">
            </div>
            <div class="input-field col-md-6 mb-2">
                <label for="email_candidato" class="form-label small text-muted">E-mail</label>
                <input type="email" class="form-control" id="email_candidato" name="email_candidato">
            </div>
            <div class="input-field col-6 mb-2">
                <label for="bilhete_candidato" class="form-label small text-muted">Número de Bilhete</label>
                <input type="text" class="form-control" id="bilhete_candidato" name="bilhete_candidato">
            </div>
            <div class="input-field col-6 mb-2">
                <label for="telefone_candidato" class="form-label small text-muted">Número de telefone</label>
                <input type="text" class="form-control" id="telefone_candidato" name="telefone_candidato" placeholder="+244 222-222-222">
            </div>

            <div class="input-field col-md-6 mb-2">
                <label for="vaga_id" class="form-label small text-muted">Vaga</label>
                <select id="vaga_id" name="vaga_id" class="form-select">
                <option selected disabled>Escolha uma opção</option>
                <?php $__currentLoopData = $vagas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $vaga): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($vaga->vaga_id); ?>"><?php echo e($vaga->nome_vaga); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>

            <div class="input-field col-md-6 mb-2">
                <label for="doc_anexo" class="form-label small text-muted">Anexar documentos</label>
                <input type="file" class="form-control" id="doc_anexo" name="doc_anexo[]" multiple>
            </div>

            <div class="form-check small d-flex align-items-center gap-2">
                <input class="form-check-input" type="checkbox" id="criar_conta" name="criar_conta">
                <label class="form-check-label" for="criar_conta">
                    Criar uma conta após o envio da candidatura?
                </label>
            </div>
            <div class="input-field col-md-6">
                 <button class="btn btn-dark" type="submit">Enviar</button>
            </div>

        </form>
    </div>
</section>



<?php echo $__env->make('components.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php $__env->stopSection(); ?>


<?php $__env->startPush('scripts'); ?>
 <script>
        gsap.registerPlugin( ScrollSmoother);

        let smoothers = ScrollSmoother.get();

        const modal = document.querySelector('.modal');

        console.log(modal);

        modal.addEventListener('show.bs.modal', () => {
        smoothers && smoothers.paused(true);
        console.log("desligado")
        });

        modal.addEventListener('hidden.bs.modal', () => {
        smoothers && smoothers.paused(false);
        });
    </script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('modals'); ?>


<?php if(isset($vaga->vaga_id)): ?>
<div class="modal fade" id="vagaModal<?php echo e($vaga->vaga_id); ?>" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h1 class="modal-title fs-5" id="exampleModalLabel"><?php echo e($vaga->nome_vaga); ?></h1>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <p class="text-muted small"><?php echo e($vaga->descricao_vaga); ?></p>
        <p class="text-muted small m-0">Total de vagas: <?php echo e($vaga->numero_vaga); ?></p>
        <p class="text-muted small m-0">Data: <?php echo e($vaga->data_inicio); ?> à <?php echo e($vaga->data_fim); ?></p>

      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-primary">Candidatar-se</button>
      </div>
    </div>
  </div>
</div>
<?php endif; ?>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\website-van_thanh\resources\views/website/work-us.blade.php ENDPATH**/ ?>