<!-- Bootstrap Table with Header - Dark -->
<div class="card">
    <div class="card-header">
        <h5>Tabela de candidaturas</h5>
        <form method="GET" action="<?php echo e(route('candidaturas-clientes.index')); ?>" id="formSearch">
        <div>
            <div class="input-group input-group-merge">
            <span id="basic-icon-default-fullname2" class="input-group-text"
                ><i class="icon-base bx bx-search"></i
            ></span>
                <input
                type="text"
                class="form-control"
                id="search"
                name="search"
                placeholder="Pesquisar"
                value="<?php echo e(request('search')); ?>"
                aria-label="Pesquisar"
                aria-describedby="basic-icon-default-fullname2" />

            </div>
        </div>
        </form>
    </div>
    <div class="table-responsive text-nowrap">
        <table class="table">
            <thead class="table-dark">
                <tr>
                <th>Obra</th>
                <th>Referência</th>
                <th>Custo</th>
                <th>Data de inicio</th>
                <th>Acções</th>
                </tr>
            </thead>
            <tbody class="table-border-bottom-0">
                <?php if($obras->isEmpty()): ?>
                    <tr>
                        <td colspan="7" class="text-center" style="font-size: 15px;">
                            Nenhum resultado encontrado
                        </td>
                    </tr>
                <?php else: ?>
                    <?php $__currentLoopData = $obras; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $obra): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td class="text-primary"><?php echo e($obra->nome_obra); ?></td>
                        <td><?php echo e($obra->ref_obra); ?></td>

                        <td>
                            <?php if($obra->relatorio->obra_id != null): ?>
                                Possui anexos
                            <?php else: ?>
                                Ainda sem anexos
                            <?php endif; ?>
                        </td>
                        <td><?php echo e($obra->data_inicio); ?></td>
                        <td>
                            <div class="dropdown">
                            <button type="button" class="btn p-0 dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                                <i class="icon-base bx bx-dots-vertical-rounded"></i>
                            </button>
                            <div class="dropdown-menu">
                                <a class="dropdown-item" href="javascript:void(0);"
                                ><i class="icon-base bx bx-trash me-1"></i> Eliminar</a
                                >
                            </div>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>
<!--/ Bootstrap Table with Header Dark -->
<?php /**PATH C:\laragon\www\website-van_thanh\resources\views/dashboard/client/pages/projectos/_includes/tabela-projectos.blade.php ENDPATH**/ ?>