<!-- Bootstrap Table with Header - Dark -->
<div class="card">
    <div class="card-header">
        <h5>Tabela de projectos</h5>
        <form method="GET" action="<?php echo e(route('projectos.index')); ?>" id="formSearch">
        <div>
            <div class="input-group input-group-merge">
            <span id="basic-icon-default-fullname2" class="input-group-text"
                ><i class="icon-base bx bx-search"></i
            ></span>
                <input
                type="text"
                class="form-control"
                id="search"
                name="search"
                placeholder="Pesquisar"
                value="<?php echo e(request('search')); ?>"
                aria-label="Pesquisar"
                aria-describedby="basic-icon-default-fullname2" />
            
            </div>
        </div>
        </form>
    </div>
    <div class="table-responsive text-nowrap">
        <table class="table">
            <thead class="table-dark">
                <tr>
                <th title="">Nome do projecto</th>
                <th>Referência</th>
                <th>Nome do cliente</th>
                <th>ENG Responsável</th>
                <th>Custo Total</th>
                <th>Estado</th>
                <th>Acções</th>
                </tr>
            </thead>
            <tbody class="table-border-bottom-0">
                <?php if($projectos->isEmpty()): ?>
                       <tr>
                            <td colspan="7" class="text-center" style="font-size: 15px;">
                                Nenhum resultado encontrado
                            </td>
                        </tr>
                <?php else: ?>
                    <?php $__currentLoopData = $projectos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $projecto): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                        <td><img src="<?php echo e(asset('storage/' .$projecto->imagem_projecto)); ?>" width="80" height="80" class="#" style="object-fit: cover"> <?php echo e($projecto->nome_projecto); ?></td>
                
                        <td><span class="badge bg-label-primary me-1"><?php echo e($projecto->referencia_projecto); ?></span></td>
                    
                        <td><?php echo e($projecto->nome_cliente); ?></td>
                        <td><?php echo e($projecto->engenheiro_resp); ?></td>
                        <td><?php echo e(number_format($projecto->custo_total, 2, ',', '.')); ?> 
                            <?php if($projecto->moeda == "Dolar_americano"): ?> USD <?php elseif($projecto->moeda == "Kwanza"): ?> AOA <?php else: ?> EUR <?php endif; ?>
                        </td>
                        <td><?php echo e($projecto->estado); ?></td>
                        <td>
                            <div class="dropdown">
                            <button type="button" class="btn p-0 dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                                <i class="icon-base bx bx-dots-vertical-rounded"></i>
                            </button>
                            <div class="dropdown-menu">
                                <a class="dropdown-item" href="javascript:void(0);"
                                ><i class="icon-base bx bx-edit-alt me-1"></i> Edit</a
                                >
                                <a class="dropdown-item" href="javascript:void(0);"
                                ><i class="icon-base bx bx-show me-1"></i> Galeria</a
                                >
                                <a class="dropdown-item" href="javascript:void(0);"
                                ><i class="icon-base bx bx-trash me-1"></i> Delete</a
                                >
                            </div>
                            </div>
                        </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
                    
                
            </tbody>
        </table>
    </div>
</div>
<!--/ Bootstrap Table with Header Dark -->
<?php /**PATH C:\laragon\www\website-van_thanh\resources\views/dashboard/admin/pages/projectos/_includes/tabela-projectos.blade.php ENDPATH**/ ?>