<?php
    $dataNascimento = null;

    if (Auth::user()->painel === 'Administrador' && Auth::user()->funcionario) {
        $dataNascimento = Auth::user()->funcionario->data_nascimento;
    }

    if (Auth::user()->painel === 'Cliente' && Auth::user()->cliente) {
        $dataNascimento = Auth::user()->cliente->data_nascimento;
    }
?>





<?php $__env->startSection('title', 'meu-perfil'); ?>

<?php $__env->startSection('container-dashboard'); ?>
     <div class="layout-page">
          <!-- Navbar -->
            <?php echo $__env->make('layouts._includes.nav-menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
          <!-- / Navbar -->

          <!-- Content wrapper -->
          <div class="content-wrapper">
            <!-- Content -->
            <div class="container-xxl flex-grow-1 container-p-y">
              <div class="row">
                <div class="col-md-12">
                  <div class="nav-align-top">
                    <ul class="nav nav-pills flex-column flex-md-row mb-6 gap-md-0 gap-2">
                      <li class="nav-item">
                        <a class="nav-link active" href="javascript:void(0);"
                          ><i class="icon-base bx bx-user icon-sm me-1_5"></i> Conta</a
                        >
                      </li>
                    </ul>
                  </div>
                  <div class="card mb-6">
                    <!-- Account -->
                    <div class="card-body">
                      <div class="d-flex align-items-start align-items-sm-center gap-6 pb-4 border-bottom">

                          <?php if(Auth::user()->imagem_usuario): ?>
                            <img src="<?php echo e(asset('storage/' . Auth::user()->imagem_usuario)); ?>"alt="<?php echo e(Auth::user()->email_acesso); ?>"  class="d-block w-px-100 h-px-100 rounded" id="uploadedAvatar" style="object-fit:cover">
                          <?php else: ?>
                            <img src="<?php echo e(asset('dashboard/img/avatars/1.png')); ?>" alt="<?php echo e(Auth::user()->email_acesso); ?>" class="d-block w-px-100 h-px-100 rounded" id="uploadedAvatar" style="object-fit:cover" />
                          <?php endif; ?>
                        <form action="<?php echo e(route('update.imagem')); ?>" method="POST" enctype="multipart/form-data">
                          <?php echo csrf_field(); ?>
                        <div class="button-wrapper">
                          <label for="upload" class="btn btn-primary me-3 mb-4" tabindex="0">
                            <span class="d-none d-sm-block">Carregar nova foto</span>
                            <i class="icon-base bx bx-upload d-block d-sm-none"></i>
                            <input
                              type="file"
                              id="upload"
                              name="imagem"
                              class="account-file-input"
                              hidden
                              accept="image/png, image/jpeg" />
                          </label>

                          <div>Formatos JPG, GIF ou PNG. Tamanho máximo of 2050 K</div>
                          <button type="submit" class="mt-2 btn btn-dark">Salvar</button>
                        </div>
                        </form>
                      </div>
                    </div>
                    <div class="card-body pt-4">
                      <form id="formAccountSettings" method="POST"  action="<?php echo e(route('update.perfil', Auth::user()->usuario_id)); ?>">
                        <?php echo csrf_field(); ?>
                        <div class="row g-6">
                          <div class="col-md-6">
                            <label for="firstName" class="form-label">Nome completo</label>
                            <input
                              class="form-control"
                              type="text"
                              id="nome_completo"
                              name="nome_completo"
                              value="<?php if(Auth::user()->painel === 'Administrador'): ?><?php echo e(Auth::user()->funcionario->nome_funcionario); ?> <?php elseif(Auth::user()->painel === 'Cliente'): ?><?php echo e(Auth::user()->cliente->nome_cliente); ?> <?php endif; ?>"
                              autofocus />
                          </div>
                          <div class="col-md-6">
                            <label for="email" class="form-label">E-mail</label>
                            <input
                              class="form-control"
                              type="email"
                              id="email"
                              name="email"
                              value="<?php echo e(Auth::user()->email_acesso); ?>"
                               />
                          </div>
                          <?php if(Auth::user()->painel === 'Cliente'): ?>
                            <div class="col-md-6">
                              <label for="telefone" class="form-label">Telefone</label>
                              <input
                                type="text"
                                class="form-control"
                                id="telefone"
                                name="telefone"
                                value="<?php echo e(Auth::user()->cliente->telefone); ?>" />
                            </div>
                          <?php endif; ?>

                        <?php if(Auth::user()->painel === 'Cliente'): ?>
                            <div class="col-md-6">
                              <label for="bilhete_cliente" class="form-label">Número de bilhete</label>
                              <input
                                type="text"
                                class="form-control"
                                id="bilhete_cliente"
                                name="bilhete_cliente"
                                value="<?php echo e(Auth::user()->cliente->bilhete_cliente); ?>" />
                            </div>
                        <?php endif; ?>
                          <div class="col-md-12">
                            <label class="form-label" for="data_nascimento">Data de nascimento</label>
                            <div class="input-group input-group-merge">

                                <input
                                type="date"
                                id="data_nascimento"
                                name="data_nascimento"
                                class="form-control"
                                 value="<?php echo e(old('data_nascimento', $dataNascimento)); ?>"
                                />
                            </div>
                          </div>
                        </div>
                        <div class="mt-6">
                          <button type="submit" class="btn btn-primary me-3">Salvar alterações</button>
                        </div>
                      </form>
                    </div>
                    <!-- /Account -->
                  </div>
                  <div class="card">
                    <h5 class="card-header">Deletar conta</h5>
                    <div class="card-body">
                      <div class="mb-6 col-12 mb-0">
                        <div class="alert alert-warning">
                          <h5 class="alert-heading mb-1">Tem a certeza que pretende deletar sua conta?</h5>
                          <p class="mb-0">Ao eliminar sua conta, o processo não pode ser desfeito. Ainda pode reconsiderar</p>
                        </div>
                      </div>
                      <form id="formAccountDeactivation" action="<?php echo e(route('destroy.perfil', Auth::user()->usuario_id)); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>
                        <div class="form-check my-8 ms-2">
                          <input
                            class="form-check-input"
                            type="checkbox"
                            name="accountActivation"
                            id="accountActivation" />
                          <label class="form-check-label" for="accountActivation"
                            >Eu confirmo a desativação da minha conta</label
                          >
                        </div>
                        <button type="submit" class="btn btn-danger deactivate-account">Desativar conta</button>
                      </form>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            <!-- / Content -->

            <div class="content-backdrop fade"></div>
          </div>
          <!-- Content wrapper -->
        </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.dashboard', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\website-van_thanh\resources\views/dashboard/config/perfil.blade.php ENDPATH**/ ?>