<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <meta name="description" content="VAN THANH – CONSTRUÇÃO CIVIL, (SU), LDA" />
    


    
    <link rel="stylesheet" href="<?php echo e(asset('bootstrap/dist/css/bootstrap.min.css')); ?>">

    
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:ital,opsz,wght@0,14..32,100..900;1,14..32,100..900&family=Roboto+Mono:ital,wght@0,100..700;1,100..700&family=Sora:wght@500&display=swap" rel="stylesheet">

   <!-- Boxicons CSS -->
     
    <link href='https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css' rel='stylesheet'>


    
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@12/swiper-bundle.min.css"/>

    
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/app.css')); ?>"/>
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/login.css')); ?>"/>
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/app-responsive.css')); ?>"/>


    <!-- GSAP core -->
    <script src="https://cdn.jsdelivr.net/npm/gsap@3.14.1/dist/gsap.min.js"></script>

    <!-- Plugin ScrollTrigger -->
    <script src="https://cdn.jsdelivr.net/npm/gsap@3.14.1/dist/ScrollTrigger.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.13.0/ScrollSmoother.min.js"></script>

    <title>Van Thanh – Construção Civil  | <?php echo $__env->yieldContent('title'); ?></title>
</head>
<body>

    <div class="menus">
        <?php echo $__env->make('components.nav-menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </div>

    <div id="smooth-wrapper">
        <main id="smooth-content">
            <?php echo $__env->yieldContent('content'); ?>
        </main>
    </div>

    <?php echo $__env->make('components.menu-toggle', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    
    <?php echo $__env->yieldPushContent('modals'); ?>



    <!-- Swiper JS -->
    <script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js"></script>

    
    <script src="<?php echo e(asset('bootstrap/dist/js/bootstrap.bundle.min.js')); ?>"></script>

    
    <script src="https://unpkg.com/boxicons@2.1.3/dist/boxicons.js"></script>

    <script>
        gsap.registerPlugin(ScrollTrigger, ScrollSmoother);

        const smoother = ScrollSmoother.create({
        wrapper: "#smooth-wrapper",
        content: "#smooth-content",
        smooth: 2,
        effects: true
        });

        const menu = document.querySelector('.mainMenu');

        ScrollTrigger.create({
            start: "top -100",
            onEnter: () => menu.classList.add('menu-fixed'),
            onLeaveBack: () => menu.classList.remove('menu-fixed')
        });
    </script>
    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>

<?php /**PATH C:\laragon\www\website-van_thanh\resources\views/layouts/main.blade.php ENDPATH**/ ?>