@extends('layouts.main')

@section('content')


<section class="page-work-us header">

    <div class="hero-section d-flex">
        <div class="text-desc ">
            <h1 class="fw-bold">Junte-se a nossa equipe</h1>
            <p class="small my-4 text-muted">Lorem ipsum dolor sit amet consectetur, adipisicing elit. Dolorum quos, vero minima fugiat a numquam rerum cum odio aperiam repudiandae distinctio? Quae quaerat cupiditate ipsa excepturi temporibus obcaecati tempore eveniet.</p>
        </div>

        <div class="hero-img ">
            <img src="{{ asset('assets/img/Search.png') }}" alt="image-2" width="200">
        </div>
    </div>
</section>

<section class="jobs">
    <div class="filters d-flex justify-content-center align-items-center mb-4">
        <div class="search d-flex align-items-center">
            <i class="bx bx-search"></i>
            <input type="search" placeholder="Pesquisar algo" name="search-job">
        </div>
    </div>

    <div class="card-jobs d-flex justify-content-between flex-wrap gap-4">
        @if($vagas->isEmpty())
            <p class="text-muted text-center w-100">Nenhuma vaga encontrada</p>
        @else
            @foreach ($vagas as $vaga )
                <div class="card-jobs-item shadow-sm">
                    <div class="image">
                        @if ($vaga->imagem_vaga === null)
                            <img src="{{ asset('assets/img/background17.jpg') }}" alt="{{ $vaga->nome_vaga }}" width="200">
                        @else
                            <img src="{{ asset('storage/' .$vaga->imagem_vaga) }}" alt="{{ $vaga->nome_vaga }}" width="200">
                        @endif


                        @if (now()->lte($vaga->data_fim))
                            <p class="open bg-success">Aberto</p>
                        @else
                            <p class="open bg-success">Fechado</p>
                        @endif
                    </div>
                    <div class="desc p-3">
                        <p class="m-0">{{ $vaga->nome_vaga }}</p>
                        <span class="text-muted" style="font-size:12px">Inicio em {{ $vaga->data_inicio }}</span>
                        <button data-bs-toggle="modal" data-bs-target="#vagaModal{{ $vaga->vaga_id }}">Ver detalhes</button>
                    </div>
                </div>

            @endforeach
        @endif
    </div>

    <div class="form p-3">
        <div class="desc text-center mb-4">
            <p class="fw-bold m-0">Formulário de candidatura</p>
            <span class="text-muted small">Lorem ipsum dolor sit amet consectetur adipisicing elit. Libero, optio odit corporis ipsam, at eveniet natus culpa repudiandae perferendis, dolorem a quia. Provident nam quidem deleniti amet. Accusamus, facilis quidem.</span>
        </div>
        <form action="{{ route('salvar-candidatura') }}" class="row g-3" method="post">
            @csrf
            <div class="input-field col-md-6 mb-2">
                <label for="nome_candidato" class="form-label small text-muted">Nome Completo</label>
                <input type="text" class="form-control" id="nome_candidato" name="nome_candidato">
            </div>
            <div class="input-field col-md-6 mb-2">
                <label for="email_candidato" class="form-label small text-muted">E-mail</label>
                <input type="email" class="form-control" id="email_candidato" name="email_candidato">
            </div>
            <div class="input-field col-6 mb-2">
                <label for="bilhete_candidato" class="form-label small text-muted">Número de Bilhete</label>
                <input type="text" class="form-control" id="bilhete_candidato" name="bilhete_candidato">
            </div>
            <div class="input-field col-6 mb-2">
                <label for="telefone_candidato" class="form-label small text-muted">Número de telefone</label>
                <input type="text" class="form-control" id="telefone_candidato" name="telefone_candidato" placeholder="+244 222-222-222">
            </div>

            <div class="input-field col-md-6 mb-2">
                <label for="vaga_id" class="form-label small text-muted">Vaga</label>
                <select id="vaga_id" name="vaga_id" class="form-select">
                <option selected disabled>Escolha uma opção</option>
                @foreach ($vagas as $vaga )
                    <option value="{{ $vaga->vaga_id }}">{{ $vaga->nome_vaga }}</option>
                @endforeach
                </select>
            </div>

            <div class="input-field col-md-6 mb-2">
                <label for="doc_anexo" class="form-label small text-muted">Anexar documentos</label>
                <input type="file" class="form-control" id="doc_anexo" name="doc_anexo[]" multiple>
            </div>

            <div class="form-check small d-flex align-items-center gap-2">
                <input class="form-check-input" type="checkbox" id="criar_conta" name="criar_conta">
                <label class="form-check-label" for="criar_conta">
                    Criar uma conta após o envio da candidatura?
                </label>
            </div>
            <div class="input-field col-md-6">
                 <button class="btn btn-dark" type="submit">Enviar</button>
            </div>

        </form>
    </div>
</section>



@include('components.footer')

@endsection


@push('scripts')
 <script>
        gsap.registerPlugin( ScrollSmoother);

        let smoothers = ScrollSmoother.get();

        const modal = document.querySelector('.modal');

        console.log(modal);

        modal.addEventListener('show.bs.modal', () => {
        smoothers && smoothers.paused(true);
        console.log("desligado")
        });

        modal.addEventListener('hidden.bs.modal', () => {
        smoothers && smoothers.paused(false);
        });
    </script>
@endpush

@push('modals')


@if (isset($vaga->vaga_id))
<div class="modal fade" id="vagaModal{{ $vaga->vaga_id }}" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h1 class="modal-title fs-5" id="exampleModalLabel">{{ $vaga->nome_vaga }}</h1>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <p class="text-muted small">{{ $vaga->descricao_vaga }}</p>
        <p class="text-muted small m-0">Total de vagas: {{ $vaga->numero_vaga }}</p>
        <p class="text-muted small m-0">Data: {{ $vaga->data_inicio }} à {{ $vaga->data_fim }}</p>

      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-primary">Candidatar-se</button>
      </div>
    </div>
  </div>
</div>
@endif

@endpush
