@extends('layouts.main')

@section('content')


<section class="page-blog header">
     <div class="hero-section d-flex">
            <div class="text-desc ">
                <h1 class="fw-bold">Mantenha-se sempre actualizado</h1>
                <p class="small my-4 text-muted">Lorem ipsum dolor sit amet consectetur, adipisicing elit. Dolorum quos, vero minima fugiat a numquam rerum cum odio aperiam repudiandae distinctio? Quae quaerat cupiditate ipsa excepturi temporibus obcaecati tempore eveniet.</p>
            </div>

           <div class="hero-img ">
                <img src="{{ asset('assets/img/background18.jpg') }}" alt="image-2" width="200">
           </div>
    </div>
</section>


<section class="news">
    <div class="filters-menu ">
        <ul class="d-flex list-unstyled justify-content-center gap-4">
            <li class="{{ !request()->has('tipo') ? 'active' : '' }}">
                <a href="{{ route('blog') }}" class="text-decoration-none">
                    Todas noticias
                </a>
            </li>

            <li class="{{ request('tipo') == 'actualizacoes' ? 'active' : '' }}">
                <a href="{{ route('blog', ['tipo' => 'actualizacoes']) }}" class="text-decoration-none">
                    Actualizações
                </a>
            </li>

            <li class="{{ request('tipo') == 'projectos' ? 'active' : '' }}">
                <a href="{{ route('blog', ['tipo' => 'projectos']) }}" class="text-decoration-none">
                    Projectos
                </a>
            </li>

            <li class="{{ request('tipo') == 'tendencias' ? 'active' : '' }}">
                <a href="{{ route('blog', ['tipo' => 'tendencias']) }}" class="text-decoration-none">
                    Tendências
                </a>
            </li>

            <li class="{{ request('tipo') == 'dicas' ? 'active' : '' }}">
                <a href="{{ route('blog', ['tipo' => 'dicas']) }}" class="text-decoration-none">
                    Dicas de Construção
                </a>
            </li>
        </ul>


        <form method="GET" action="{{ route('blog') }}" class="btn-filter-toggle d-none w-100 d-flex gap-2">
                <div class="input-field w-100">
                    <select name="tipo" class="form-select">
                        <option value=""
                        {{ !request()->has('tipo') ? 'active' : '' }}>Todas</option>

                        <option value="actualizacoes"
                            {{ request('tipo') === 'actualizacoes' ? 'selected' : '' }}>
                            Actualizações
                        </option>

                        <option value="projectos"
                            {{ request('tipo') === 'projectos' ? 'selected' : '' }}>
                            Projectos
                        </option>

                        <option value="tendencias"
                            {{ request('tipo') === 'tendencias' ? 'selected' : '' }}>
                            Tendências
                        </option>

                        <option value="dicas"
                            {{ request('tipo') === 'dicas' ? 'selected' : '' }}>
                            Dicas de Construção
                        </option>
                    </select>
                </div>

                <button class="btn btn-dark" type="submit">
                    <i class="bx bx-filter-alt"></i> Filtrar
                </button>
        </form>


    </div>

    <div class="news-content">
        <div class="news-content-item d-flex" style="gap:20px">
            @if(!$destaque)
                <p class="fs-3 text-center fw-bold">Não existe destaque</p>
            @else
            <div class="featured-news w-100">
                <div class="image">
                    <img src="{{ asset('storage/' .$destaque->path_imagem) }}" alt="{{ $destaque->titulo_noticia}}" width="200"/>
                    <p>Destaque</p>
                </div>
                <div class="desc">
                    <p class="fs-4">{{ $destaque->titulo_noticia}}</p>
                    <p class="text-muted">{{ $destaque->descricao}}</p>
                    <p class="text-muted d-flex" style="gap:10px;font-size:12px">
                        <span class="by">By {{$destaque->autor_noticia}}</span>
                        <span>|</span>
                        <span>Publicado em {{$destaque->data_publicacao->format('d/m/Y')}}</span>
                    </p>
                    <a href="">Ler mais</a>
                </div>
            </div>
            @endif
            <div class="stories w-100">
                <p>Últimos históricos</p>
                <div class="stories-card p-4">
                    @foreach($ultimas_noticias as $un)
                    <div class="stories-card-item">
                        <div class="image"><img src="{{ asset('storage/' .$un->path_imagem) }}" alt="{{ $destaque->titulo_noticia}}" width="80"></div>
                        <div class="desc">
                            <p class="small m-0">{{ $un->titulo_noticia}}</p>
                            <p class="text-muted m-0 d-flex" style="gap:10px;font-size:12px">
                                <span class="by">By {{$un->autor_noticia}}</span>
                                <span>|</span>
                                <span>Publicado em {{$un->data_publicacao->format('d/m/Y')}}</span>
                            </p>
                            <a href="">Ler mais</a>
                        </div>
                    </div>
                    <hr style="color:#D8DCE1;">
                    @endforeach
                </div>
            </div>
        </div>
        <hr style="color:#D8DCE1;">
        <p class="title mt-5">Outras notícias</p>
        <div class="card-news-content mb-3 p-4 d-flex">
            @foreach ($noticias as $noticia )
                <div class="card-news-content-item shadow-sm flex-fill">
                    <div class="image"><img src="{{ asset('storage/' .$noticia->path_imagem) }}" alt="{{ $destaque->titulo_noticia}}" width="80"></div>
                    <div class="desc">
                        <p class="small m-0">{{ $noticia->titulo_noticia}}</p>
                        <p class="text-muted m-0 d-flex" style="gap:10px;font-size:12px">
                            <span class="by">By {{$noticia->autor_noticia}}</span>
                            <span>|</span>
                            <span>Publicado em {{$noticia->data_publicacao->format('d/m/Y')}}</span>
                        </p>
                        <a href="">Ler mais</a>
                    </div>
                </div>
            @endforeach

        </div>
        @include('components.pagination')
    </div>
</section>




@include('components.footer')

@endsection

