<!-- Bootstrap Table with Header - Dark -->
<div class="card">
    <div class="card-header">
        <h5>Tabela de candidaturas</h5>
        <form method="GET" action="{{ route('candidaturas-clientes.index') }}" id="formSearch">
        <div>
            <div class="input-group input-group-merge">
            <span id="basic-icon-default-fullname2" class="input-group-text"
                ><i class="icon-base bx bx-search"></i
            ></span>
                <input
                type="text"
                class="form-control"
                id="search"
                name="search"
                placeholder="Pesquisar"
                value="{{ request('search') }}"
                aria-label="Pesquisar"
                aria-describedby="basic-icon-default-fullname2" />

            </div>
        </div>
        </form>
    </div>
    <div class="table-responsive text-nowrap">
        <table class="table">
            <thead class="table-dark">
                <tr>
                <th>Obra</th>
                <th>Referência</th>
                <th>Custo</th>
                <th>Data de inicio</th>
                <th>Acções</th>
                </tr>
            </thead>
            <tbody class="table-border-bottom-0">
                @if ($obras->isEmpty())
                    <tr>
                        <td colspan="7" class="text-center" style="font-size: 15px;">
                            Nenhum resultado encontrado
                        </td>
                    </tr>
                @else
                    @foreach ($obras as $obra )
                    <tr>
                        <td class="text-primary">{{$obra->nome_obra}}</td>
                        <td>{{$obra->ref_obra}}</td>

                        <td>
                            @if ($obra->relatorio->obra_id != null)
                                Possui anexos
                            @else
                                Ainda sem anexos
                            @endif
                        </td>
                        <td>{{$obra->data_inicio}}</td>
                        <td>
                            <div class="dropdown">
                            <button type="button" class="btn p-0 dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                                <i class="icon-base bx bx-dots-vertical-rounded"></i>
                            </button>
                            <div class="dropdown-menu">
                                <a class="dropdown-item" href="javascript:void(0);"
                                ><i class="icon-base bx bx-trash me-1"></i> Eliminar</a
                                >
                            </div>
                            </div>
                        </td>
                    </tr>
                    @endforeach
                @endif
            </tbody>
        </table>
    </div>
</div>
<!--/ Bootstrap Table with Header Dark -->
