<!-- Bootstrap Table with Header - Dark -->
<div class="card">
    <div class="card-header">
        <h5>Tabela de candidaturas</h5>
        <form method="GET" action="{{ route('candidaturas-clientes.index') }}" id="formSearch">
        <div>
            <div class="input-group input-group-merge">
            <span id="basic-icon-default-fullname2" class="input-group-text"
                ><i class="icon-base bx bx-search"></i
            ></span>
                <input
                type="text"
                class="form-control"
                id="search"
                name="search"
                placeholder="Pesquisar"
                value="{{ request('search') }}"
                aria-label="Pesquisar"
                aria-describedby="basic-icon-default-fullname2" />
            
            </div>
        </div>
        </form>
    </div>
    <div class="table-responsive text-nowrap">
        <table class="table">
            <thead class="table-dark">
                <tr>
                <th>Número de candidatura</th>
                <th>Vaga</th>
                <th>Status</th>
                <th>Anexos</th>
                <th>Acções</th>
                </tr>
            </thead>
            <tbody class="table-border-bottom-0">
                @if ($candidaturas->isEmpty())
                    <tr>
                        <td colspan="7" class="text-center" style="font-size: 15px;">
                            Nenhum resultado encontrado
                        </td>
                    </tr>
                @else
                    @foreach ($candidaturas as $candidatura )
                    <tr>
                        <td class="text-primary">{{$candidatura->numero_registro}}</td>
                        <td>{{$candidatura->vaga->nome_vaga}}</td>
                        <td>@if ($candidatura->status == 'Pendente')
                            <span class="badge bg-label-warning me-1">{{$candidatura->status}}</span>
                            @elseif ($candidatura->status == 'Aprovado')
                            <span class="badge bg-label-success me-1">{{$candidatura->status}}</span>
                            @else
                            <span class="badge bg-label-danger me-1">{{$candidatura->status}}</span>
                            @endif
                        </td>
                        <td>
                            @if ($candidatura->anexo_id)
                                
                            @else

                            @endif
                        </td>
                        <td>
                            <div class="dropdown">
                            <button type="button" class="btn p-0 dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                                <i class="icon-base bx bx-dots-vertical-rounded"></i>
                            </button>
                            <div class="dropdown-menu">
                                <a class="dropdown-item" href="javascript:void(0);"
                                ><i class="icon-base bx bx-trash me-1"></i> Eliminar</a
                                >
                            </div>
                            </div>
                        </td>
                    </tr>
                    @endforeach
                @endif
            </tbody>
        </table>
    </div>
</div>
<!--/ Bootstrap Table with Header Dark -->
