
<div class="card">
    <div class="card-header">
        <h5>Tabela de usuários</h5>
        <form method="GET" action="{{ route('usuarios.index') }}" id="formSearch">
        <div>
            <div class="input-group input-group-merge">
            <span id="basic-icon-default-fullname2" class="input-group-text"
                ><i class="icon-base bx bx-search"></i
            ></span>
                <input
                type="text"
                class="form-control"
                id="search"
                name="search"
                placeholder="Pesquisar"
                value="{{ request('search') }}"
                aria-label="Pesquisar"
                aria-describedby="basic-icon-default-fullname2" />

            </div>
        </div>
        </form>
    </div>
    <div class="table-responsive text-nowrap">
        <table class="table">
            <thead class="table-dark">
                <tr>
                <th>Nome completo</th>
                <th>E-mail de acesso</th>
                <th>Imagem</th>
                <th>Status</th>
                <th>Painel de acesso</th>
                <th>Acções</th>
                </tr>
            </thead>
            <tbody class="table-border-bottom-0">
                 @if ($usuarios->isEmpty())
                       <tr>
                            <td colspan="7" class="text-center" style="font-size: 15px;">
                                Nenhum resultado encontrado
                            </td>
                        </tr>
                   @else
                       @foreach ($usuarios as $usuario )
                        <tr>
                            <td>
                            @if ($usuario->painel == 'Cliente')
                            {{$usuario->cliente->nome_cliente}}
                            @else
                            {{$usuario->funcionario->nome_funcionario}}
                            @endif
                        </td>

                        <td>{{$usuario->email_acesso}}</td>

                        <td>
                            @if ($usuario->imagem_usuario)
                                <img src="{{ asset('storage/' . $usuario->imagem_usuario) }}" width="80" height="80" class="#" style="object-fit: cover">
                            @else
                                Nenhuma imagem adicionada
                            @endif
                        </td>
                        <td>
                            @if ($usuario->status)
                                <span class="badge bg-label-primary me-1">Activado</span>
                            @else
                                <span class="badge bg-label-danger me-1">Desativado</span>
                            @endif
                        </td>
                        <td>{{$usuario->painel}}</td>

                        <td>
                            <div class="dropdown">
                            <button type="button" class="btn p-0 dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                                <i class="icon-base bx bx-dots-vertical-rounded"></i>
                            </button>
                            <div class="dropdown-menu">
                                <a class="dropdown-item" data-bs-toggle="modal"  href="#modal_editar_usuario{{$usuario->usuario_id}}"
                                ><i class="icon-base bx bx-edit-alt me-1"></i> Editar</a
                                >
                                <a class="dropdown-item" href="{{route('usuarios.destroy', $usuario->usuario_id)}}"
                                ><i class="icon-base bx bx-trash me-1"></i> Deletar</a
                                >
                            </div>
                            </div>
                        </td>
                        </tr>


                        @include('dashboard.admin.pages.usuarios._includes.modal-editar-usuario')
                       @endforeach
                   @endif
            </tbody>
        </table>
    </div>
</div>

