<!-- Bootstrap Table with Header - Dark -->
<div class="card">
    <div class="card-header">
        <h5>Tabela de obras</h5>
        <form method="GET" action="{{ route('obras.index') }}" id="formSearch">
        <div>
            <div class="input-group input-group-merge">
            <span id="basic-icon-default-fullname2" class="input-group-text"
                ><i class="icon-base bx bx-search"></i
            ></span>
                <input
                type="text"
                class="form-control"
                id="search"
                name="search"
                placeholder="Pesquisar"
                value="{{ request('search') }}"
                aria-label="Pesquisar"
                aria-describedby="basic-icon-default-fullname2" />

            </div>
        </div>
        </form>
    </div>
    <div class="table-responsive text-nowrap">
        <table class="table">
            <thead class="table-dark">
                <tr>
                <th title="">Nome da Obra</th>
                <th>Referência</th>
                <th>Nome do cliente</th>
                <th>Tipo de obra</th>
                <th>Custo Total</th>
                <th>Acções</th>
                </tr>
            </thead>
            <tbody class="table-border-bottom-0">
                @if ($obras->isEmpty())
                       <tr>
                            <td colspan="7" class="text-center" style="font-size: 15px;">
                                Nenhum resultado encontrado
                            </td>
                        </tr>
                @else
                    @foreach ($obras as $obra )
                        <tr>
                        <td> {{$obra->nome_obra}}</td>

                        <td><span class="badge bg-label-primary me-1">{{$obra->ref_obra}}</span></td>

                        <td>
                            @if ($obra->cliente_id == null)
                                Não vinculado ainda
                            @else
                                {{$obra->cliente->nome_cliente}}
                            @endif
                        </td>
                        <td>{{$obra->tipo_servico}} - {{$obra->tipo_projecto}}</td>
                        <td>{{ number_format($obra->custo_total, 2, ',', '.') }}
                            @if ($obra->moeda == "Dolar_americano") USD @elseif($obra->moeda == "Kwanza") AOA @else EUR @endif
                        </td>
                        <td>
                            <div class="dropdown">
                            <button type="button" class="btn p-0 dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                                <i class="icon-base bx bx-dots-vertical-rounded"></i>
                            </button>
                            <div class="dropdown-menu">
                                <a class="dropdown-item" href="{{ route('obras.edit', $obra->obra_id) }}"
                                ><i class="icon-base bx bx-edit-alt me-1"></i> Edit</a
                                >
                                <a class="dropdown-item" href="#modal_relatorio{{ $obra->obra_id }}" data-bs-toggle="modal"
                                ><i class="icon-base bx bx-edit-alt me-1"></i> Relatório</a
                                >
                                <form action="{{ route('obras.destroy', $obra->obra_id) }}" method="post">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="dropdown-item"><i class="icon-base bx bx-trash me-1"></i> Delete</button>
                                </form>
                            </div>
                            </div>
                        </td>
                        </tr>
                        @include('dashboard.admin.pages.obras._includes.modal-add-relatorio')
                    @endforeach
                @endif


            </tbody>
        </table>
    </div>
</div>
<!--/ Bootstrap Table with Header Dark -->
