<!-- Bootstrap Table with Header - Dark -->
<div class="card">
    <div class="card-header">
        <h5>Tabela de projectos</h5>
        <form method="GET" action="{{ route('projectos.index') }}" id="formSearch">
        <div>
            <div class="input-group input-group-merge">
            <span id="basic-icon-default-fullname2" class="input-group-text"
                ><i class="icon-base bx bx-search"></i
            ></span>
                <input
                type="text"
                class="form-control"
                id="search"
                name="search"
                placeholder="Pesquisar"
                value="{{ request('search') }}"
                aria-label="Pesquisar"
                aria-describedby="basic-icon-default-fullname2" />

            </div>
        </div>
        </form>
    </div>
    <div class="table-responsive text-nowrap">
        <table class="table">
            <thead class="table-dark">
                <tr>
                <th title="">Titulo da noticia</th>
                <th>Descrição</th>
                <th>Autor</th>
                <th>Tipo de noticia</th>
                <th>Data de publicação</th>
                <th>Acções</th>
                </tr>
            </thead>
            <tbody class="table-border-bottom-0">
                @if ($noticias->isEmpty())
                       <tr>
                            <td colspan="7" class="text-center" style="font-size: 15px;">
                                Nenhum resultado encontrado
                            </td>
                        </tr>
                @else
                    @foreach ($noticias as $noticia )
                        <tr>
                        <td title="{{ $noticia->titulo_noticia }}" ><img src="{{ asset('storage/' .$noticia->path_imagem) }}" width="80" height="80" class="#" style="object-fit: cover"> {{ Str::limit($noticia->titulo_noticia, 10, '...') }}</td>
                        <td title="{{ $noticia->descricao }}">{{ Str::limit($noticia->descricao, 30, '...') }}</td>
                        <td>{{$noticia->autor_noticia}}</td>
                        <td>
                            <span class="badge
                                @if($noticia->tipoNoticia->nome_tipo === 'Tendências') bg-label-primary
                                @elseif($noticia->tipoNoticia->nome_tipo === 'Actualizações') bg-label-success
                                @elseif($noticia->tipoNoticia->nome_tipo === 'Dicas de Construção') bg-label-danger
                                @elseif($noticia->tipoNoticia->nome_tipo === 'Projectos') bg-label-dark
                                @endif
                                me-1">
                                {{ $noticia->tipoNoticia->nome_tipo }}
                            </span>
                        </td>
                        <td>{{$noticia->data_publicacao}}</td>
                        <td>
                            <div class="dropdown">
                            <button type="button" class="btn p-0 dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                                <i class="icon-base bx bx-dots-vertical-rounded"></i>
                            </button>
                            <div class="dropdown-menu">
                                <a class="dropdown-item" href="javascript:void(0);"
                                ><i class="icon-base bx bx-edit-alt me-1"></i> Edit</a
                                >
                                <a class="dropdown-item" href="javascript:void(0);"
                                ><i class="icon-base bx bx-trash me-1"></i> Delete</a
                                >
                            </div>
                            </div>
                        </td>
                        </tr>
                    @endforeach
                @endif


            </tbody>
        </table>
    </div>
</div>
<!--/ Bootstrap Table with Header Dark -->
