@extends('layouts.main')

@section('content')


<section class="page-login header">
    <div class="header-content w-100">
        <div class="menus">
            @include('components.nav-menu')
        </div>
    </div>

     <div class="form-content">
        <h3 class="text-white text-uppercase text-center mb-4" style="letter-spacing: 1px">Acessar agora</h2>
        <form action="{{ route('auth.login') }}" method="post">
            @csrf
            <div class="input-field">
                <span><i class="bx bx-user"></i></span>
                <input type="text" name="email_acesso" id="email_acesso" placeholder="Username">
            </div>
            <div class="input-field">
                <span><i class="bx bx-lock"></i></span>
                <input type="password" name="password" id="password" placeholder="Password">
            </div>
            <button>Iniciar Sessão</button>

            <a href="{{ route('esqueceu-senha') }}" class="forget-password d-flex small text-decoration-none text-white justify-content-end" style="letter-spacing: 1px">Esqueceu sua senha?</a>
            <ul class="m-0 d-flex justify-content-between list-unstyled">
                <li class="text-uppercase"><a href="{{ route('criar.conta') }}">Criar Conta</a></li>
                <li class="text-uppercase"><a href="">Precisa de Ajuda?</a></li>
            </ul>
        </form>
    </div>
    
    <footer class="d-flex justify-content-between align-items-center">
        <div class="item">
            <ul class="d-flex list-unstyled m-0">
                <li>Sobre Nós</li>
                <li>Privacidade e Politicas</li>
                <li>Termos de uso</li>
            </ul>
        </div>
        <div class="item">
        <p class="m-0">©2025  Van Thanh. Direitos Reservados | Design by Codnet - Tecnologias</p>
        </div>
    </footer>
</section>




@include('messages.toast')

@endsection

