<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasOne;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;

class Usuario extends Authenticatable
{
    public $timestamps = false;

    protected $primaryKey = 'usuario_id';

    use HasApiTokens, HasFactory, Notifiable;

    protected $fillable = [
        'email_acesso',
        'password',
        'imagem_usuario',
        'estado',
        'painel'
    ];

    protected $hidden = [
        'password'
    ];

    protected $casts = [
        'password' => 'hashed',
    ];

    public function cliente(): HasOne
    {
        return $this->hasOne(Cliente::class, 'usuario_id');
    }

    public function funcionario(): HasOne
    {
        return $this->hasOne(Funcionario::class, 'usuario_id');
    }
}
