<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Servico extends Model
{
    public $timestamps = false;

    protected $primaryKey = 'servico_id';
    use HasFactory;

    protected $fillable = [
        'nome_servico',
        'descricao',
        'imagem',
        'categoria_servico_id'
    ];

    public function categoriaServico(): BelongsTo
    {
        return $this->belongsTo(Categoria_servico::class, 'categoria_servico_id');
    }
}
