<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Noticia extends Model
{
    const CREATED_AT = "data_publicacao";
    const UPDATED_AT = null;

    protected $primaryKey = 'noticia_id';
    use HasFactory;

    protected $fillable = [
        'titulo_noticia',
        'descricao',
        'tipo_noticia_id',
        'autor_noticia',
        'path_imagem',
        'destaque',
        'data_publicacao',
    ];

    public function tipoNoticia(): BelongsTo
    {
        return $this->belongsTo(Tipo_noticia::class, 'tipo_noticia_id');
    }
}
