<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Funcionario extends Model
{
    public $timestamps = false;

    protected $primaryKey = 'funcionario_id';

    use HasFactory;

    protected $fillable = [
        'nome_funcionario',
        'data_nascimento',
        'cargo',
        'usuario_id'
    ];
    public function usuario():BelongsTo
    {
        return $this->belongsTo(Usuario::class, 'usuario_id', 'usuario_id');
    }
}
