<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Cliente extends Model
{
    const CREATED_AT = 'data_registro';
    const UPDATED_AT = null;

    protected $primaryKey = 'cliente_id';
    use HasFactory;

    protected $fillable = [
        'nome_cliente',
        'email_cliente',
        'bilhete_cliente',
        'usuario_id',
        'data_registro'
    ];


    public function candidatura(): HasMany
    {
        return $this->hasMany(Candidatura::class, 'cliente_id');
    }

    public function usuario():BelongsTo
    {
        return $this->belongsTo(Usuario::class, 'usuario_id', 'usuario_id');
    }

    public function obra():HasMany{
        return $this->hasMany(Obra::class, 'cliente_id');
    }


}
