<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

class RestauroController extends Controller
{
    public function index(){
        return view('dashboard.admin.pages.restaurar.restauraSystema');
    }
    
    public function restore(Request $request)
    {
        // Tabelas que você quer limpar (fixo)
        $tables = ['pedidos', 'produtos', 'categorias'];

        Schema::disableForeignKeyConstraints();

        foreach ($tables as $table) {
            if (Schema::hasTable($table)) {
                DB::table($table)->truncate();
            }
        }

        Schema::enableForeignKeyConstraints();

        return redirect()->back()->with('success', 'Tabelas restauradas com sucesso!');
    }
}
