<?php

namespace App\Http\Controllers;

use App\Models\Usuario;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Intervention\Image\Drivers\Gd\Driver;
use Intervention\Image\ImageManager;

class PerfilController extends Controller
{
    public function updatePerfil(Request $request, string $id){

        $user = Auth::user();

        if($user->usuario_id == $id){

            $usuario = Usuario::findOrFail($id);
            if($user->painel === 'Administrador'){

                $usuario->update([
                    'email_acesso' => $request->email
                ]);

                $usuario->funcionario()->update([
                    'nome_funcionario' => $request->nome_completo,
                    'data_nascimento' => $request->data_nascimento
                ]);
            }
            else if($user->painel === 'Cliente'){
                $usuario->update([
                    'email_acesso' => $request->email
                ]);

                $usuario->cliente()->update([
                    'nome_cliente' => $request->nome_completo,
                    'email_cliente' => $request->email,
                    'bilhete_cliente' => $request->bilhete_cliente,
                    'data_nascimento' => $request->data_nascimento,
                    'telefone' => $request->telefone
                ]);
            }

            return redirect()->back()->with([
                'toast_message' => 'perfil actualizado',
                'toast_type' => 'success'
            ]);
        }

    }

    public function updateImagem(Request $request){
        $manager = new ImageManager(new Driver());

        $usuario = Usuario::where('usuario_id', Auth::user()->usuario_id)->first();
        if ($request->hasFile('imagem')) {

            // Salvar o arquivo original SEM alterar
            $path = $request->file('imagem')->store('usuarios', 'public');


            $usuario->update([
                'imagem_usuario' => $path
            ]);

            return redirect()->back()->with([
                'toast_message' => 'Foto de perfil actualizado!',
                'toast_type' => 'success'
            ]);
        }
    }

    public function destroyAccount(Request $request, string $id){
        $usuario = Usuario::findOrFail($id);

        if($usuario){

            if($request->accountActivation)
                $usuario->delete();

            return redirect()->route('login')->with([
                'toast_message' => 'Conta eliminada',
                'toast_type' => 'success'
            ]);
        }
    }
}
