<?php

namespace App\Http\Controllers;

use App\Models\Cliente;
use App\Models\Projecto;
use App\Models\Noticia;
use App\Models\Vaga;
use Illuminate\Http\Request;
use Illuminate\View\View;

class AppController extends Controller
{
    public function index():View{
        return view('website.index');
    }
    public function about():View{
        return view('website.about');
    }

    public function blog(Request $request):View{
        $query = Noticia::with('tipoNoticia');

        if ($request->filled('tipo')) {
            $query->whereHas('tipoNoticia', function ($q) use ($request) {
                $q->where('nome_tipo', $request->tipo);
            });
        }

        $noticias = $query->paginate(10);

        $ultimas_noticias = Noticia::latest('data_publicacao')
            ->take(4)
            ->get();

        $destaque = Noticia::where('destaque', 1)
            ->latest('data_publicacao')
            ->first();

        return view('website.blog', [
            'noticias' => $noticias,
            'ultimas_noticias' => $ultimas_noticias,
            'destaque' => $destaque
        ]);

    }
    public function work():View{
        $vagas = Vaga::all();
        return view('website.work-us', ['vagas'=> $vagas]);
    }
    public function portfolio(Request $request):View{
        $search = $request->input('search');

        $servicos = $request->input('servico', []);
        $tipos    = $request->input('projecto', []);

        $projectos = Projecto::query()
        ->when(!empty($servicos), function ($query) use ($servicos) {
            $query->whereIn('tipo_servico', $servicos);
        })
        ->when(!empty($tipos), function ($query) use ($tipos) {
            $query->whereIn('tipo_projecto', $tipos);
        })
        ->when($search, function ($query) use ($search) {
            $query->where(function ($q) use ($search) {
                $q->where('nome_projecto', 'LIKE', "%{$search}%")
                  ->orWhere('referencia_projecto', 'LIKE', "%{$search}%");
            });
        })->paginate(10);

        return view('website.portfolio',['projectos' => $projectos]);
    }

    public function news_details():View{
        return view('website.news-details');
    }

    public function project_details(String $id):View{
        $projecto = Projecto::find($id);


        return view('website.project-details', ['projecto'=> $projecto]);


    }

      public function login(): View
    {
        return view('auth.login');
    }

    public function register(): View
    {
        return view('auth.registrar');
    }

    public function painel_admin():View
    {
        $totalClientes = Cliente::count();
        return view('dashboard.admin.home', ['totalClientes'=> $totalClientes]);
    }

    public function painel_cliente(): View
    {
        return view('dashboard.client.home');
    }
    public function perfil(): View
    {

        return view('dashboard.config.perfil');
    }

    public function conta_criada(){
        return view('messages.email');
    }

    public function forget_password(){
        return view('auth.esqueceu-senha');
    }

    public function recover_password(){
        return view('auth.recuperar-senha');
    }
}
